/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;

public class LocalCBVLSNTracker {
    private final VLSNIndex vlsnIndex;
    private final int padValue;
    private VLSN nextLocalCBVLSN;
    private VLSN currentLocalCBVLSN;
    private long currentFile;
    private boolean allowUpdate = true;

    LocalCBVLSNTracker(RepNode repNode) {
        this.padValue = repNode.getRepImpl().getConfigManager().getInt(RepParams.CBVLSN_PAD);
        this.vlsnIndex = repNode.getRepImpl().getVLSNIndex();
        this.currentLocalCBVLSN = this.vlsnIndex.getRange().getLastSync();
        this.nextLocalCBVLSN = new VLSN(this.currentLocalCBVLSN.getSequence());
        this.currentFile = DbLsn.getFileNumber(-1L);
    }

    public void setAllowUpdate(boolean allowUpdate) {
        this.allowUpdate = allowUpdate;
    }

    public void track(VLSN matchableVLSN, long lsn) {
        if (!this.allowUpdate) {
            return;
        }
        if (DbLsn.getFileNumber(lsn) == this.currentFile) {
            this.nextLocalCBVLSN = matchableVLSN;
            return;
        }
        this.currentLocalCBVLSN = this.nextLocalCBVLSN;
        this.nextLocalCBVLSN = matchableVLSN;
        this.currentFile = DbLsn.getFileNumber(lsn);
    }

    public void registerMatchpoint(VLSN matchpoint) {
        this.currentLocalCBVLSN = matchpoint;
        this.nextLocalCBVLSN = new VLSN(matchpoint.getSequence());
    }

    public VLSN getBroadcastCBVLSN() {
        if (this.padValue == 0) {
            return this.currentLocalCBVLSN;
        }
        VLSN minVLSN = this.vlsnIndex.getRange().getFirst();
        long paddedCBVLSNVal = this.currentLocalCBVLSN.getSequence() - (long)this.padValue;
        if (paddedCBVLSNVal < minVLSN.getSequence()) {
            return minVLSN;
        }
        return new VLSN(paddedCBVLSNVal);
    }
}

